#include "chunkdt.h"

INT16 Chunk_DataTypes[26] = {
	DB_TEXTURE_CONTEXT, DB_TEXTURE_CONTEXT2, DB_AISCRIPT, DB_ANIMSCRIPT, DB_ANIMATED_TEXTURE_SET,
	DB_MERGED_TEXTURE_SET, DB_TEXTURE_SET, DB_PARTICLE_EMITTER, DB_PARTICLE_SOURCE, DB_PARTICLE_EFFECT,
	DB_EXPANSION_TABLE, DB_GROUP, DB_INSTANCE, DB_LOD, DB_SOMARRAYBONE, DB_SOMARRAY, DB_SINGLSOMBONE,
	DB_SINGLSOM, DB_COLLISIONSOMARRAY, DB_WORLD_EMITTERS, DB_WORLD_DISTORTIONS, DB_PARTICLE_SURFACE_LIST,
	DB_PARTICLE_LIST, DB_EMITTER_LIST, DB_VIS_REGIONS, DB_SCENE_TREE };

INT16 Chunk_VersionConsistency[26] = {
	2, 1, 1, 2, 4, 4, 4, 4, 2, 1, 1, 4, 1, 3, 2, 3, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1 };

char* ChunkDataTypeToString( dbl_chunk_header_s* pChunkInfo ) {
	switch( pChunkInfo->iDataChunkType ) {
		case DB_TEXTURE_CONTEXT:
			return "DB_TEXTURE_CONTEXT";
		break;
		case DB_AISCRIPT:
			return "DB_AISCRIPT";
		break;
		case DB_ANIMSCRIPT:
			return "DB_ANIMSCRIPT";
		break;
		case DB_ANIMATED_TEXTURE_SET:
			return "DB_ANIMATED_TEXTURE_SET";
		break;
		case DB_MERGED_TEXTURE_SET:
			return "DB_MERGED_TEXTURE_SET";
		break;
		case DB_TEXTURE_SET:
			return "DB_TEXTURE_SET";
		break;
		case DB_PARTICLE_EMITTER:
			return "DB_PARTICLE_EMITTER";
		break;
		case DB_PARTICLE_SOURCE:
			return "DB_PARTICLE_SOURCE";
		break;
		case DB_PARTICLE_EFFECT:
			return "DB_PARTICLE_EFFECT";
		break;
		case DB_EXPANSION_TABLE:
			return "DB_EXPANSION_TABLE";
		break;
		case DB_GROUP:
			return "DB_GROUP";
		break;
		case DB_INSTANCE:
			return "DB_INSTANCE";
		break;
		case DB_LOD:
			return "DB_LOD";
		break;
		case DB_SOMARRAYBONE:
			return "DB_SOMARRAYBONE";
		break;
		case DB_SOMARRAY:
			return "DB_SOMARRAY";
		break;
		case DB_SINGLSOMBONE:
			return "DB_SINGLSOMBONE";
		break;
		case DB_SINGLSOM:
			return "DB_SINGLSOM";
		break;
		case DB_COLLISIONSOMARRAY:
			return "DB_COLLISIONSOMARRAY";
		break;
		case DB_WORLD_EMITTERS:
			return "DB_WORLD_EMITTERS";
		break;
		case DB_WORLD_DISTORTIONS:
			return "DB_WORLD_DISTORTIONS";
		break;
		case DB_PARTICLE_SURFACE_LIST:
			return "DB_PARTICLE_SURFACE_LIST";
		break;
		case DB_PARTICLE_LIST:
			return "DB_PARTICLE_LIST";
		break;
		case DB_EMITTER_LIST:
			return "DB_EMITTER_LIST";
		break;
		case DB_VIS_REGIONS:
			return "DB_VIS_REGIONS";
		break;
		case DB_SCENE_TREE:
			return "DB_SCENE_TREE";
		break;
		default:
			return "Unknown";
		break;
	}
}

INT16 ChunkDataTypeFromString( String^ dt ) {
	if( dt == "DB_TEXTURE_CONTEXT" ) return DB_TEXTURE_CONTEXT;
	else if( dt == "DB_AISCRIPT" ) return DB_AISCRIPT;
	else if( dt == "DB_ANIMSCRIPT" ) return DB_ANIMSCRIPT;
	else if( dt == "DB_ANIMATED_TEXTURE_SET" ) return DB_ANIMATED_TEXTURE_SET;
	else if( dt == "DB_MERGED_TEXTURE_SET" ) return DB_MERGED_TEXTURE_SET;
	else if( dt == "DB_TEXTURE_SET" ) return DB_TEXTURE_SET;
	else if( dt == "DB_PARTICLE_EMITTER" ) return DB_PARTICLE_EMITTER;
	else if( dt == "DB_PARTICLE_SOURCE" ) return DB_PARTICLE_SOURCE;
	else if( dt == "DB_PARTICLE_EFFECT" ) return DB_PARTICLE_EFFECT;
	else if( dt == "DB_EXPANSION_TABLE" ) return DB_EXPANSION_TABLE;
	else if( dt == "DB_GROUP" ) return DB_GROUP;
	else if( dt == "DB_LOD" ) return DB_LOD;
	else if( dt == "DB_SOMARRAYBONE" ) return DB_SOMARRAYBONE;
	else if( dt == "DB_SOMARRAY" ) return DB_SOMARRAY;
	else if( dt == "DB_SINGLSOMBONE" ) return DB_SINGLSOMBONE;
	else if( dt == "DB_SINGLSOM" ) return DB_SINGLSOM;
	else if( dt == "DB_COLLISIONSOMARRAY" ) return DB_COLLISIONSOMARRAY;
	else if( dt == "DB_WORLD_EMITTERS" ) return DB_WORLD_EMITTERS;
	else if( dt == "DB_WORLD_DISTORTIONS" ) return DB_WORLD_DISTORTIONS;
	else if( dt == "DB_PARTICLE_SURFACE_LIST" ) return DB_PARTICLE_SURFACE_LIST;
	else if( dt == "DB_PARTICLE_LIST" ) return DB_PARTICLE_LIST;
	else if( dt == "DB_EMITTER_LIST" ) return DB_EMITTER_LIST;
	else if( dt == "DB_VIS_REGIONS" ) return DB_VIS_REGIONS;
	else if( dt == "DB_SCENE_TREE" ) return DB_SCENE_TREE;
	else return -1;
}

BOOL CheckChunkDataTypeForVersion( INT chunktype, INT version ) {
	INT i = 0;
	for( ; i < 25; i++ ) {
		if( Chunk_DataTypes[i] == chunktype ) break; // Look for the chunktype first
	}
	if( Chunk_VersionConsistency[i] == version ) return TRUE;
	else return FALSE;
}